/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.item;

import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.item.Items;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.texture.Textures;
import net.jayjay.dangerzone.world.World;

public class Item {
    public String texturePath;
    public final String itemTag;
    public int durability;

    public Item(String tag) {
        this.itemTag = tag;
        ++Items.itemLimit;
    }

    public Item(String tag, String texturePath) {
        this(tag);
        this.texturePath = texturePath;
    }

    public void render(Tesselator t, World level, int layer, int x, int y, int z) {
        float c1 = 1.0f;
        t.setColor(c1, c1, c1);
        if (this.texturePath != null) {
            Textures.bindNearest(this.texturePath);
        }
        this.renderFace(t, x, y, z);
    }

    protected String getTexturePath() {
        return this.texturePath;
    }

    public boolean isUseable() {
        return false;
    }

    public void onUse(EntityPlayer player) {
    }

    public void renderFace(Tesselator tess, float x, float y, float z) {
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        float x0 = x + 0.0f;
        float x1 = x + 1.0f;
        float y0 = y + 0.0f;
        float y1 = y + 1.0f;
        float z0 = z + 0.0f;
        tess.addVertexWithUV(x0, y1, z0, u1, v0);
        tess.addVertexWithUV(x1, y1, z0, u0, v0);
        tess.addVertexWithUV(x1, y0, z0, u0, v1);
        tess.addVertexWithUV(x0, y0, z0, u1, v1);
    }

    public void renderFaceBillboarded(Tesselator t, float x, float y, float z, float xa, float ya, float za, float xa2, float za2, float size) {
        if (this.texturePath != null) {
            Textures.bindNearest(this.texturePath);
        }
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = 0.0f;
        float v1 = 1.0f;
        float r = 0.1f * size;
        t.addVertexWithUV(x - xa * r - xa2 * r, y - ya * r, z - za * r - za2 * r, u0, v1);
        t.addVertexWithUV(x - xa * r + xa2 * r, y + ya * r, z - za * r + za2 * r, u0, v0);
        t.addVertexWithUV(x + xa * r + xa2 * r, y + ya * r, z + za * r + za2 * r, u1, v0);
        t.addVertexWithUV(x + xa * r - xa2 * r, y - ya * r, z + za * r - za2 * r, u1, v1);
    }

    public void renderFaceNoTexture(Tesselator tess, float x, float y, float z) {
        float x0 = x + 0.0f;
        float x1 = x + 1.0f;
        float y0 = y + 0.0f;
        float y1 = y + 1.0f;
        float z0 = z + 0.0f;
        tess.addVertex(x0, y1, z0);
        tess.addVertex(x1, y1, z0);
        tess.addVertex(x1, y0, z0);
        tess.addVertex(x0, y0, z0);
    }
}

